echo off
cls
rem ------------------------------------------------------------------
rem
rem                          DEMOLTC.BAT
rem                version for macromodel release 2.0
rem                       Walt Jung 05/04/90
rem
rem This batch file will run a DEMO version of PSPICE, and do a test
rem simulation with a specified ".CIR" file, supplied on this diskette.
rem
rem Usage is  "DEMOLTC" (or "DEMOLTC 1007"), to run a default LT1007 demo.
rem or, alternately, the forms below:
rem
rem Summary of usage:
rem"DEMOLTC"       (to run the default LT1007 example),
rem"DEMOLTC RIAA"  (to run the RIAA demo),
rem"DEMOLTC 1078"  (to run the LT1078 data sheet demo),
rem"DEMO EXAMPLE1" (to run the PSpice example1)
rem
rem ------------------------------------------------------------------
rem look at command line tail and evaluate
rem ------------------------------------------------------------------
if (%1)==() goto demo           : default to LT1007, if nothing spec'd
if (%1)==(1007) goto demo       : default also, if asked for 1007
if (%1)==(1078) goto demo       : if asked for 1078
if (%1)==(1056) goto demo       : if asked for 1056
if (%1)==(RIAA) goto demo       : RIAA demo
if (%1)==(riaa) goto demo       : ditto
if (%1)==(example1) goto demo   : PSpice demo
if (%1)==(EXAMPLE1) goto demo   : ditto
:telerr
rem ------------------------------------------------------------------
rem if this far, all not well. abort with msg above, and note bad cmd
rem ------------------------------------------------------------------
cls
echo  
echo  
echo  
echo Sorry, but we need a correct NAME to complete the DEMO run.
echo  
echo Available are: "RIAA", "EXAMPLE1", etc., as shown below.
echo  
echo  
echo Re-enter command as "DEMOLTC" (default), or one of the following options:
echo  
echo "DEMOLTC RIAA"     or, alternately, just
echo "DEMOLTC"          (either will run the default LT1007 example),
echo  
echo "DEMOLTC RIAA"     (will run an LT1115 data sheet RIAA preamp demo),
echo "DEMOLTC 1078"     (will run an LT1078 data sheet full-wave rect. demo),
echo "DEMOLTC 1056"     (will run an LT1056 data sheet asymmetric SR demo),
echo "DEMO EXAMPLE1"    (will run the PSpice Example1 demo)
echo  
echo  
goto badxt
:demo
rem ------------------------------------------------------------------
rem make sure in root DIR, then log into SPICE DIR
rem ------------------------------------------------------------------
:spicedir
rem was: "cd \SPICE" 12/03/90
cd SPICE
:scrubfiles     
rem ------------------------------------------------------------------
rem clean up old stuff not needed, need LOTS of room!
rem ------------------------------------------------------------------
if exist *.dat del *.dat
if exist *.out del *.out
if exist *.log del *.log
if exist *.tmp del *.tmp
:tstfiles
cls
rem ------------------------------------------------------------------
rem test for existence of necessary files on disc, if no, warn & exit
rem ------------------------------------------------------------------
if exist pspice1.exe goto psexeok1      : pspice1 here?
goto nofiles                            : nope abort
:psexeok1                               
if exist probe.exe goto prbok           : how about probe?
goto nofiles                            : abort
:prbok
if not exist demo1007.cir goto nofiles  : check here for ALL CIR files
:demook                                 : first look for default,
:demoexam2                              : then finally PSpice example1
if not exist example1.cir goto nofiles
goto fileok                             : if any above missing, abort
:nofiles
rem ------------------------------------------------------------------
rem beep (once) for some missing or no files and warn
rem ------------------------------------------------------------------
cls
echo   
echo  
echo  
echo DEMO PSpice and Probe files not found!  Copy to SPICE subdir,
echo then rerun this DEMOLTC batch file.
echo  
echo  
cd..
goto badxt                              : bypass all and exit
:fileok
rem ------------------------------------------------------------------
rem Ok, we can NOW run the demo!
rem ------------------------------------------------------------------
cls
echo  
echo Now loading PSPICE for DEMO run, please wait...
echo  
if (%1)==() goto demodef        : default if nothing else requested
if (%1)==(1007) goto demodef    : default if asked 'demo1007'
:demowild                       : test for example1, otherwise fall into DEMO%1
if (%1)==(example1) goto example1
if (%1)==(EXAMPLE1) goto example1
: if not default, not ex1, must be wildcard, any %1 4char (or less)
PSPICE1 DEMO%1
IF ERRORLEVEL 1 GOTO EXIT
IF EXIST PROBE.DAT  GOTO PROBE
:example1                       : come here, if DEMOLTC EXAMPLE1 (special case)
PSPICE1 example1 %2
IF ERRORLEVEL 1 GOTO EXIT
IF EXIST PROBE.DAT  GOTO PROBE
:demodef                        : come here for default demo
PSPICE1 DEMO1007 %2
IF ERRORLEVEL 1 GOTO EXIT
IF EXIST PROBE.DAT  GOTO PROBE
:abort
rem ------------------------------------------------------------------
rem it is assumed we are calling for probe, if NO PROBE.DAT,
rem this means error(s),  fall into abort
rem ------------------------------------------------------------------
cls
echo Error(s) encountered, no "PROBE.DAT" file created.
echo Check files on diskette for integrity.
echo                                               
echo           
goto badxt
:probe
rem ------------------------------------------------------------------
rem NOW(!) run probe (after some more testing)
rem ------------------------------------------------------------------
:p1
if exist DEMO%1.CMD goto p3
if exist demo1007.cmd goto p3
if exist example1.cmd goto p3
if exist demo1078.cmd goto p3
:p2
rem ------------------------------------------------------------------
rem if any CDM file, jump around below,
rem otherwise fall into plain vanilla probe
rem ------------------------------------------------------------------
cls
echo Now calling PSpice PROBE for output display.  When the
echo PROBE menu appears, enter commands (less quotes) as follows:
echo                                               
echo  
echo A) Enter a "1"  or "Enter" (to 'Add trace')
echo  
echo B) Enter "V(55)", then "Enter" (to display the PSpice output)
echo  
echo C) Enter an "8", then "Enter" (to optionally printout the trace)
echo (but only if you have verified "PROBE.DEV" matches your printer!)
echo  
echo  
echo This PROBE display uses "TEXT" for the display mode. If you have
echo a graphic display such as Ega, Cga, Hercules, the README file in
echo the SPICE directory tells you how to set up probe for nice graphics.
echo  
echo (DO write the above down if PROBE is not familiar, then...)
pause
cls
echo  
echo Now loading PROBE for DEMO display, please wait...
echo  
pause
probe probe.dat
rem ------------------------------------------------------------------
rem now finished with probe, start exit
rem ------------------------------------------------------------------
goto p4
:p3
rem ------------------------------------------------------------------
rem come here when any CDM file, run probe with canned cmds
rem ------------------------------------------------------------------
cls
echo  
echo Now loading PROBE for DEMO display, please wait...
echo  
if (%1)==(RIAA) goto p31
if (%1)==(riaa) goto p31
:addmore options here if (%1)==(RIAA) goto p31
:addmore options here if (%1)==(riaa) goto p31
if (%1)==() goto p32
if (%1)==(1007) goto p32
if (%1)==(EXAMPLE1) goto p33
if (%1)==(example1) goto p33
rem
if exist DEMO%1.CMD goto p31
if exist demo1007.cmd goto p32
:p31                    : run this if DEMOLTC xxxx on dos cmd line
if not exist DEMO%1.cmd goto p2
probe probe.dat /cDEMO%1.CMD /lDEMO%1.LOG
goto p4
:p32                    : run this if DEMOLTC or DEMOLTC 1007 on dos cmd line
if not exist DEMO1007.cmd goto p2
probe probe.dat /cDEMO1007.CMD /lDEMO1007.LOG
goto p4
:p33                    : run this if DEMO EXAMPLE1 on dos cmd line
if not exist example1.cmd goto p2
probe probe.dat /cexample1.CMD /lexample1.LOG
:p4                     : just about done now
cd..
rem now back where we started from
goto exitnorm
:exitnorm               : tell user about files to study
cls
echo  
echo Your PSpice ASCII output file is available in SPICE\*.OUT.
echo  
echo Related SPICE files are ".CIR", ".CMD", and ".LOG".
echo  
echo Note!  Also see the important info contained in README, and SPICE\README2.
echo  
:badxt                  : come here if something went wrong (msgs above)
:exit
